/* TOS 4.04 DSP patch for the CT60 board
*  Didier Mequignon 2001 December, e-mail: aniplay@wanadoo.fr
*
*  This library is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Lesser General Public
*  License as published by the Free Software Foundation; either
*  version 2.1 of the License, or (at your option) any later version.
*
*  This library is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Lesser General Public License for more details.
*
*  You should have received a copy of the GNU Lesser General Public
*  License along with this library; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

	.text


/* XBIOS  96 */

	.align	2
	.long	0x00005124	/* offset ROM */
	.long	end01-begin01
begin01:
	.short	0x5380	/* 0x4A80 */
	.short	0x6B18	/* 0x6700 */
	.short	0x0838	/* 0x001C */
	.short	0x0001	/* 0x5340 */
	.short	0xA202	/* 0x0838 */
	.short	0x67F8	/* 0x0001 */
	.short	0x11D8	/* 0xA202 */
	.short	0xA205	/* 0x67F8 */
end01:

	.align	2
	.long	0x00005136	/* offset ROM */
	.long	end02-begin02
begin02:
	.short	0xA206	/* 0xA205 */
end02:

	.align	2
	.long	0x0000513A	/* offset ROM */
	.long	end03-begin03
begin03:
	.short	0xA207	/* 0xA206 */
	.short	0x51C8	/* 0x11D8 */
	.short	0xFFEA	/* 0xA207 */
	.short	0x5381	/* 0x51C8 */
	.short	0x6B18	/* 0xFFF2 */
	.short	0x0838	/* 0x4A81 */
	.short	0x0000	/* 0x6700 */
	.short	0xA202	/* 0x001C */
	.short	0x67F8	/* 0x5341 */
	.short	0x12F8	/* 0x0838 */
	.short	0xA205	/* 0x0000 */
	.short	0x12F8	/* 0xA202 */
	.short	0xA206	/* 0x67F8 */
end03:

	.align	2
	.long	0x00005156	/* offset ROM */
	.long	end04-begin04
begin04:
	.short	0xA207	/* 0xA205 */
	.short	0x51C9	/* 0x12F8 */
	.short	0xFFEA	/* 0xA206 */
	.short	0x4E75	/* 0x12F8 */
end04:


/* XBIOS  97 */

	.align	2
	.long	0x00005176	/* offset ROM */
	.long	end05-begin05
begin05:
	.short	0x5380	/* 0x4A80 */
	.short	0x6B18	/* 0x6700 */
	.short	0x0838	/* 0x001C */
	.short	0x0001	/* 0x5340 */
	.short	0xA202	/* 0x0838 */
	.short	0x67F8	/* 0x0001 */
	.short	0x11D8	/* 0xA202 */
	.short	0xA205	/* 0x67F8 */
end05:

	.align	2
	.long	0x00005188	/* offset ROM */
	.long	end06-begin06
begin06:
	.short	0xA206	/* 0xA205 */
end06:

	.align	2
	.long	0x0000518C	/* offset ROM */
	.long	end07-begin07
begin07:
	.short	0xA207	/* 0xA206 */
	.short	0x51C8	/* 0x11D8 */
	.short	0xFFEA	/* 0xA207 */
	.short	0x5381	/* 0x51C8 */
	.short	0x6B18	/* 0xFFEA */
	.short	0x0838	/* 0x4A81 */
	.short	0x0000	/* 0x6700 */
	.short	0xA202	/* 0x001C */
	.short	0x67F8	/* 0x5341 */
	.short	0x12F8	/* 0x0838 */
	.short	0xA205	/* 0x0000 */
	.short	0x12F8	/* 0xA202 */
	.short	0xA206	/* 0x67F8 */
end07:

	.align	2
	.long	0x000051A8	/* offset ROM */
	.long	end08-begin08
begin08:
	.short	0xA207	/* 0xA205 */
	.short	0x51C9	/* 0x12F8 */
	.short	0xFFEA	/* 0xA206 */
	.short	0x4E75	/* 0x12F8 */
end08:


/* XBIOS  98 */

	.align	2
	.long	0x000051C8	/* offset ROM */
	.long	end09-begin09
begin09:
	.short	0x5380	/* 0x4A80 */
	.short	0x6B10	/* 0x6700 */
	.short	0x0838	/* 0x0014 */
	.short	0x0001	/* 0x5340 */
	.short	0xA202	/* 0x0838 */
	.short	0x67F8	/* 0x0001 */
	.short	0x21D8	/* 0xA202 */
	.short	0xA204	/* 0x67F8 */
	.short	0x51C8	/* 0x21D8 */
	.short	0xFFF2	/* 0xA204 */
	.short	0x5381	/* 0x51C8 */
	.short	0x6B10	/* 0xFFFA */
	.short	0x0838	/* 0x4A81 */
	.short	0x0000	/* 0x6700 */
	.short	0xA202	/* 0x0014 */
	.short	0x67F8	/* 0x5341 */
	.short	0x22F8	/* 0x0838 */
	.short	0xA204	/* 0x0000 */
	.short	0x51C9	/* 0xA202 */
	.short	0xFFF2	/* 0x67F8 */
	.short	0x4E75	/* 0x22F8 */
end09:


/* XBIOS  99 */

	.align	2
	.long	0x0000537E	/* offset ROM */
	.long	end10-begin10
begin10:
	.short	0x43F8	/* 0x23EF */
	.short	0x16F8	/* 0x0004 */
	.short	0x22AF	/* 0x0000 */
	.short	0x0004	/* 0x16F8 */
	.short	0x236F	/* 0x23EF */
end10:

	.align	2
	.long	0x0000538A	/* offset ROM */
	.long	end11-begin11
begin11:
	.short	0x0008	/* 0x0000 */
	.short	0x236F	/* 0x1700 */
	.short	0x000C	/* 0x23EF */
	.short	0x0010	/* 0x000C */
	.short	0x236F	/* 0x0000 */
	.short	0x0010	/* 0x1708 */
	.short	0x0018	/* 0x23EF */
	.short	0x2069	/* 0x0010 */
	.short	0x0018	/* 0x0000 */
	.short	0x4290	/* 0x1710 */
	.short	0x2029	/* 0x2079 */
	.short	0x0008	/* 0x0000 */
	.short	0x6714	/* 0x1710 */
	.short	0x41FA	/* 0x20BC */
	.short	0x0062	/* 0x0000 */
	.short	0x21C8	/* 0x0000 */
	.short	0x03FC	/* 0x2039 */
	.short	0x11FC	/* 0x0000 */
	.short	0x00FF	/* 0x1700 */
	.short	0xA203	/* 0x6700 */
	.short	0x0038	/* 0x0016 */
	.short	0x0002	/* 0x21FC */
	.short	0xA200	/* 0x00E0 */
	.short	0x4E71	/* 0x5416 */
	.short	0x4E71	/* 0x03FC */
	.short	0x4E71	/* 0x11FC */
	.short	0x4E71	/* 0x00FF */
	.short	0x4E71	/* 0xA203 */
	.short	0x4E71	/* 0x0038 */
	.short	0x4E71	/* 0x0002 */
	.short	0x4E71	/* 0xA200 */
end11:


/* XBIOS 100 */

	.align	2
	.long	0x000053CA	/* offset ROM */
	.long	end12-begin12
begin12:
	.short	0x43F8	/* 0x23EF */
	.short	0x16F8	/* 0x0004 */
	.short	0x236F	/* 0x0000 */
	.short	0x0004	/* 0x16FC */
	.short	0x0004	/* 0x23EF */
	.short	0x236F	/* 0x0008 */
	.short	0x0008	/* 0x0000 */
	.short	0x000C	/* 0x1704 */
	.short	0x236F	/* 0x23EF */
end12:

	.align	2
	.long	0x000053DE	/* offset ROM */
	.long	end13-begin13
begin13:
	.short	0x0014	/* 0x0000 */
	.short	0x236F	/* 0x170C */
	.short	0x0010	/* 0x23EF */
	.short	0x001C	/* 0x0010 */
	.short	0x2069	/* 0x0000 */
	.short	0x001C	/* 0x1714 */
	.short	0x4290	/* 0x2079 */
	.short	0x2029	/* 0x0000 */
	.short	0x000C	/* 0x1714 */
	.short	0x6714	/* 0x20BC */
	.short	0x41FA	/* 0x0000 */
	.short	0x0014	/* 0x0000 */
	.short	0x21C8	/* 0x2039 */
	.short	0x03FC	/* 0x0000 */
	.short	0x11FC	/* 0x1704 */
	.short	0x00FF	/* 0x6700 */
	.short	0xA203	/* 0x0016 */
	.short	0x0038	/* 0x21FC */
	.short	0x0001	/* 0x00E0 */
	.short	0xA200	/* 0x5416 */
	.short	0x4E75	/* 0x03FC */
	.short	0x48E7	/* 0x11FC */
	.short	0x80C0	/* 0x00FF */
	.short	0x43F8	/* 0xA203 */
	.short	0x16F8	/* 0x0038 */
	.short	0x0838	/* 0x0001 */
	.short	0x0000	/* 0xA200 */
	.short	0xA202	/* 0x4E75 */
	.short	0x673E	/* 0x48E7 */
	.short	0x2029	/* 0x8080 */
	.short	0x000C	/* 0x0838 */
	.short	0x5380	/* 0x0000 */
	.short	0x6B20	/* 0xA202 */
	.short	0x2069	/* 0x6700 */
	.short	0x0004	/* 0x004A */
	.short	0x0838	/* 0x2039 */
end13:

	.align	2
	.long	0x00005428	/* offset ROM */
	.long	end14-begin14
begin14:
	.short	0xA202	/* 0x1704 */
	.short	0x67F8	/* 0x5340 */
	.short	0x10F8	/* 0x2079 */
	.short	0xA205	/* 0x0000 */
	.short	0x10F8	/* 0x16FC */
	.short	0xA206	/* 0x10F8 */
	.short	0x10F8	/* 0xA205 */
	.short	0xA207	/* 0x10F8 */
	.short	0x51C8	/* 0xA206 */
	.short	0xFFEA	/* 0x10F8 */
	.short	0x2348	/* 0xA207 */
	.short	0x0004	/* 0x51C8 */
	.short	0x2069	/* 0xFFF2 */
	.short	0x001C	/* 0x23C8 */
	.short	0x5290	/* 0x0000 */
	.short	0x2010	/* 0x16FC */
	.short	0xB0A9	/* 0x2079 */
	.short	0x0014	/* 0x0000 */
	.short	0x6640	/* 0x1714 */
	.short	0x0238	/* 0x0690 */
	.short	0x00FE	/* 0x0000 */
	.short	0xA200	/* 0x0001 */
	.short	0x6038	/* 0x2010 */
	.short	0x2029	/* 0xB0B9 */
	.short	0x0008	/* 0x0000 */
	.short	0x5380	/* 0x170C */
	.short	0x6B1C	/* 0x6600 */
	.short	0x2051	/* 0x0050 */
	.short	0x0838	/* 0x0238 */
	.short	0x0001	/* 0x00FE */
	.short	0xA202	/* 0xA200 */
	.short	0x67F8	/* 0x4EF9 */
	.short	0x11D8	/* 0x00E0 */
	.short	0xA205	/* 0x54AE */
	.short	0x11D8	/* 0x2039 */
	.short	0xA206	/* 0x0000 */
	.short	0x11D8	/* 0x1700 */
	.short	0xA207	/* 0x5340 */
	.short	0x51C8	/* 0x2079 */
	.short	0xFFEA	/* 0x0000 */
	.short	0x2288	/* 0x16F8 */
	.short	0x2069	/* 0x11D8 */
	.short	0x0018	/* 0xA205 */
	.short	0x5290	/* 0x11D8 */
	.short	0x2010	/* 0xA206 */
	.short	0xB0A9	/* 0x11D8 */
	.short	0x0010	/* 0xA207 */
	.short	0x6606	/* 0x51C8 */
	.short	0x0238	/* 0xFFF2 */
	.short	0x00FD	/* 0x23C8 */
	.short	0xA200	/* 0x0000 */
	.short	0x4CDF	/* 0x16F8 */
	.short	0x0301	/* 0x2079 */
	.short	0x4E73	/* 0x0000 */
end14:


/* XBIOS 101 */

	.align	2
	.long	0x00005296	/* offset ROM */
	.long	end15-begin15
begin15:
	.short	0x43F8	/* 0x23EF */
	.short	0x16F8	/* 0x0004 */
	.short	0x22AF	/* 0x0000 */
	.short	0x0004	/* 0x16F8 */
	.short	0x236F	/* 0x23EF */
end15:

	.align	2
	.long	0x000052A2	/* offset ROM */
	.long	end16-begin16
begin16:
	.short	0x0004	/* 0x0000 */
	.short	0x236F	/* 0x16FC */
	.short	0x000C	/* 0x23EF */
	.short	0x0008	/* 0x000C */
	.short	0x236F	/* 0x0000 */
	.short	0x0010	/* 0x1700 */
	.short	0x000C	/* 0x23EF */
	.short	0x236F	/* 0x0010 */
	.short	0x0014	/* 0x0000 */
	.short	0x0010	/* 0x1704 */
	.short	0x236F	/* 0x23EF */
	.short	0x0018	/* 0x0014 */
	.short	0x0018	/* 0x0000 */
	.short	0x2069	/* 0x1708 */
	.short	0x0018	/* 0x23EF */
	.short	0x4290	/* 0x0018 */
	.short	0x2029	/* 0x0000 */
	.short	0x0008	/* 0x1710 */
	.short	0x671C	/* 0x2079 */
	.short	0x2051	/* 0x0000 */
	.short	0x0838	/* 0x1710 */
	.short	0x0001	/* 0x20BC */
	.short	0xA202	/* 0x0000 */
	.short	0x67F8	/* 0x0000 */
	.short	0x11D8	/* 0x2039 */
	.short	0xA205	/* 0x0000 */
	.short	0x11D8	/* 0x1700 */
	.short	0xA206	/* 0x5340 */
	.short	0x11D8	/* 0x2079 */
	.short	0xA207	/* 0x0000 */
	.short	0x51C8	/* 0x16F8 */
	.short	0xFFEA	/* 0x11D8 */
	.short	0x2288	/* 0xA205 */
	.short	0x41FA	/* 0x11D8 */
	.short	0x0014	/* 0xA206 */
	.short	0x21C8	/* 0x11D8 */
	.short	0x03FC	/* 0xA207 */
	.short	0x11FC	/* 0x51C8 */
	.short	0x00FF	/* 0xFFF2 */
	.short	0xA203	/* 0x23C8 */
	.short	0x0038	/* 0x0000 */
	.short	0x0001	/* 0x16F8 */
	.short	0xA200	/* 0x21FC */
	.short	0x4E75	/* 0x00E0 */
	.short	0x48E7	/* 0x530C */
	.short	0x80C0	/* 0x03FC */
	.short	0x43F8	/* 0x11FC */
	.short	0x16F8	/* 0x00FF */
	.short	0x2029	/* 0xA203 */
	.short	0x000C	/* 0x0038 */
	.short	0x5380	/* 0x0001 */
	.short	0x6B20	/* 0xA200 */
	.short	0x2069	/* 0x4E75 */
	.short	0x0004	/* 0x48E7 */
	.short	0x0838	/* 0x8080 */
	.short	0x0000	/* 0x2039 */
	.short	0xA202	/* 0x0000 */
	.short	0x67F8	/* 0x1704 */
	.short	0x10F8	/* 0x5340 */
	.short	0xA205	/* 0x2079 */
	.short	0x10F8	/* 0x0000 */
	.short	0xA206	/* 0x16FC */
end16:

	.align	2
	.long	0x00005320	/* offset ROM */
	.long	end17-begin17
begin17:
	.short	0xA207	/* 0xA205 */
	.short	0x51C8	/* 0x10F8 */
	.short	0xFFEA	/* 0xA206 */
	.short	0x2348	/* 0x10F8 */
	.short	0x0004	/* 0xA207 */
	.short	0x2069	/* 0x51C8 */
	.short	0x0018	/* 0xFFF2 */
	.short	0x5290	/* 0x23C8 */
	.short	0x2010	/* 0x0000 */
	.short	0xB0A9	/* 0x16FC */
	.short	0x0010	/* 0x2079 */
	.short	0x6608	/* 0x0000 */
	.short	0x0238	/* 0x1710 */
	.short	0x00FE	/* 0x5290 */
	.short	0xA200	/* 0x2010 */
	.short	0x6024	/* 0xB0B9 */
	.short	0x2029	/* 0x0000 */
	.short	0x0008	/* 0x1708 */
	.short	0x5380	/* 0x6600 */
	.short	0x6B1C	/* 0x000E */
	.short	0x2051	/* 0x0238 */
	.short	0x0838	/* 0x00FE */
	.short	0x0001	/* 0xA200 */
	.short	0xA202	/* 0x4EF9 */
	.short	0x67F8	/* 0x00E0 */
	.short	0x11D8	/* 0x5378 */
	.short	0xA205	/* 0x2039 */
	.short	0x11D8	/* 0x0000 */
	.short	0xA206	/* 0x1700 */
	.short	0x11D8	/* 0x5340 */
	.short	0xA207	/* 0x2079 */
	.short	0x51C8	/* 0x0000 */
	.short	0xFFEA	/* 0x16F8 */
	.short	0x2288	/* 0x11D8 */
	.short	0x4CDF	/* 0xA205 */
	.short	0x0301	/* 0x11D8 */
	.short	0x4E73	/* 0xA206 */
end17:


/* XBIOS 102 */


/* XBIOS 103 */

	.align	2
	.long	0x000054C0	/* offset ROM */
	.long	end18-begin18
begin18:
	.short	0x7003	/* 0x303C */
	.short	0x4E75	/* 0x0003 */
end18:


/* XBIOS 104 */

	.align	2
	.long	0x0000603A	/* offset ROM */
	.long	end19-begin19
begin19:
	.short	0x3038	/* 0x3039 */
	.short	0x17DE	/* 0x0000 */
	.short	0x6606	/* 0x17DE */
	.short	0x31FC	/* 0x6600 */
	.short	0xFFFF	/* 0x000C */
	.short	0x17DE	/* 0x323C */
	.short	0x4E75	/* 0xFFFF */
end19:


/* XBIOS 105 */

	.align	2
	.long	0x00006050	/* offset ROM */
	.long	end20-begin20
begin20:
	.short	0x4278	/* 0x33FC */
	.short	0x17DE	/* 0x0000 */
	.short	0x4E75	/* 0x0000 */
end20:


/* XBIOS 106 */

	.align	2
	.long	0x0000608A	/* offset ROM */
	.long	end21-begin21
begin21:
	.short	0x2038	/* 0x2039 */
	.short	0x1780	/* 0x0000 */
	.short	0x90BC	/* 0x1780 */
	.short	0x0000	/* 0x90BC */
	.short	0x4000	/* 0x0000 */
	.short	0x2080	/* 0x4000 */
	.short	0x4E75	/* 0x2080 */
end21:


/* XBIOS 107 */

	.align	2
	.long	0x000060A4	/* offset ROM */
	.long	end22-begin22
begin22:
	.short	0x2238	/* 0x2239 */
	.short	0x1780	/* 0x0000 */
	.short	0xB081	/* 0x1780 */
	.short	0x6E14	/* 0xB081 */
	.short	0x21C0	/* 0x6E00 */
	.short	0x1788	/* 0x0020 */
	.short	0x202F	/* 0x23C0 */
	.short	0x0008	/* 0x0000 */
	.short	0xB0BC	/* 0x1788 */
	.short	0x0000	/* 0x202F */
	.short	0x3EFF	/* 0x0008 */
	.short	0x6E04	/* 0xB0BC */
	.short	0x7000	/* 0x0000 */
	.short	0x6002	/* 0x3EFF */
	.short	0x70FF	/* 0x6E00 */
	.short	0x4E75	/* 0x000C */
end22:


/* XBIOS 108 */

	.align	2
	.long	0x000058E2	/* offset ROM */
	.long	end23-begin23
begin23:
	.short	0x206F	/* 0x4E56 */
	.short	0x0004	/* 0xFFFC */
	.short	0x302F	/* 0x2F07 */
	.short	0x0008	/* 0x2E2E */
	.short	0x226F	/* 0x000E */
	.short	0x000A	/* 0x2047 */
	.short	0x3F00	/* 0x2F08 */
	.short	0x4851	/* 0x2F2E */
	.short	0x4850	/* 0x0008 */
	.short	0x3F3C	/* 0x2F48 */
	.short	0x006F	/* 0x000C */
	.short	0x4E4E	/* 0x61B4 */
	.short	0x4FEF	/* 0x504F */
	.short	0x000A	/* 0x2E00 */
	.short	0x2400	/* 0x4A87 */
	.short	0x6E06	/* 0x6F1A */
	.short	0x544F	/* 0x302E */
	.short	0x70FF	/* 0x000C */
	.short	0x6014	/* 0x33C0 */
	.short	0x226F	/* 0x0000 */
	.short	0x000C	/* 0x178C */
	.short	0x2F02	/* 0x3F00 */
	.short	0x4851	/* 0x2F07 */
	.short	0x3F3C	/* 0x2F2F */
	.short	0x006D	/* 0x000A */
	.short	0x4E4E	/* 0x6100 */
	.short	0x4FEF	/* 0x0018 */
	.short	0x000C	/* 0x4FEF */
	.short	0x7000	/* 0x000A */
	.short	0x4E75	/* 0x70FF */
end23:


/* XBIOS 109 */

	.align	2
	.long	0x0000592E	/* offset ROM */
	.long	end24-begin24
begin24:
	.short	0x42A7	/* 0x4E56 */
	.short	0x42A7	/* 0x0000 */
	.short	0x3F3C	/* 0x3F2E */
	.short	0x006E	/* 0x0010 */
	.short	0x4E4E	/* 0x4878 */
	.short	0x4FEF	/* 0x0047 */
	.short	0x000A	/* 0x4879 */
	.short	0x43EF	/* 0x00E4 */
	.short	0x0004	/* 0xAC82 */
	.short	0x2059	/* 0x4EBA */
	.short	0x2019	/* 0x0532 */
	.short	0x31D1	/* 0x7000 */
	.short	0x178C	/* 0x2E80 */
	.short	0x6114	/* 0x2F00 */
	.short	0x7017	/* 0x2F2E */
	.short	0x41F8	/* 0x000C */
	.short	0x17E2	/* 0x2F2E */
	.short	0x0838	/* 0x0008 */
	.short	0x0001	/* 0x4EBA */
	.short	0xA202	/* 0xF812 */
	.short	0x67F8	/* 0x4EBA */
	.short	0x5348	/* 0x07BE */
	.short	0x21D8	/* 0x33EE */
	.short	0xA204	/* 0x0010 */
	.short	0x51C8	/* 0x0000 */
	.short	0xFFF0	/* 0x178C */
	.short	0x4E75	/* 0x4E5E */
end24:


/* XBIOS 110 */

	.align	2
	.long	0x00005E74	/* offset ROM */
	.long	end25-begin25
begin25:
	.short	0x40E7	/* 0x40F9 */
	.short	0x007C	/* 0x0000 */
	.short	0x0700	/* 0x17E0 */
	.short	0x41F8	/* 0x46FC */
	.short	0x8800	/* 0x2700 */
	.short	0x10BC	/* 0x11FC */
end25:

	.align	2
	.long	0x00005E82	/* offset ROM */
	.long	end26-begin26
begin26:
	.short	0x1010	/* 0x8800 */
	.short	0x0880	/* 0x1038 */
	.short	0x0004	/* 0x8800 */
	.short	0x1140	/* 0x0200 */
	.short	0x0002	/* 0x00EF */
	.short	0x08C0	/* 0x11C0 */
	.short	0x0004	/* 0x8802 */
	.short	0x1140	/* 0x0000 */
	.short	0x0002	/* 0x0010 */
	.short	0x46D7	/* 0x11C0 */
	.short	0x2038	/* 0x8802 */
	.short	0x04BA	/* 0x46F9 */
	.short	0x5480	/* 0x0000 */
	.short	0x2238	/* 0x17E0 */
	.short	0x04BA	/* 0x2038 */
	.short	0xB280	/* 0x04BA */
	.short	0x6DF8	/* 0x5480 */
	.short	0x007C	/* 0x2238 */
	.short	0x0700	/* 0x04BA */
	.short	0x10BC	/* 0xB280 */
	.short	0x000E	/* 0x6DF8 */
	.short	0x1010	/* 0x40F9 */
	.short	0x0880	/* 0x0000 */
	.short	0x0004	/* 0x17E0 */
	.short	0x1140	/* 0x46FC */
	.short	0x0002	/* 0x2700 */
	.short	0x46DF	/* 0x11FC */
	.short	0xB2B8	/* 0x000E */
	.short	0x04BA	/* 0x8800 */
	.short	0x67FA	/* 0x1038 */
	.short	0x202F	/* 0x8800 */
	.short	0x0008	/* 0x0200 */
	.short	0x206F	/* 0x00EF */
	.short	0x0004	/* 0x11C0 */
	.short	0x2208	/* 0x8802 */
	.short	0x6608	/* 0x46F9 */
	.short	0x7047	/* 0x0000 */
	.short	0x41F9	/* 0x17E0 */
	.short	0x00E4	/* 0x202F */
	.short	0xAC82	/* 0x0008 */
end26:

	.align	2
	.long	0x00005EDA	/* offset ROM */
	.long	end27-begin27
begin27:
	.short	0x5380	/* 0x90BC */
	.short	0x6B18	/* 0x0000 */
	.short	0x0838	/* 0x0001 */
	.short	0x0001	/* 0x206F */
	.short	0xA202	/* 0x0004 */
	.short	0x67F8	/* 0x11D8 */
	.short	0x11D8	/* 0xA205 */
	.short	0xA205	/* 0x11D8 */
	.short	0x11D8	/* 0xA206 */
	.short	0xA206	/* 0x11D8 */
	.short	0x11D8	/* 0xA207 */
	.short	0xA207	/* 0x51C8 */
	.short	0x51C8	/* 0xFFF2 */
	.short	0xFFEA	/* 0x2201 */
	.short	0x5381	/* 0x6700 */
	.short	0x6B1A	/* 0x001E */
	.short	0x7000	/* 0x92BC */
	.short	0x0838	/* 0x0000 */
end27:

	.align	2
	.long	0x00005F00	/* offset ROM */
	.long	end28-begin28
begin28:
	.short	0xA202	/* 0x11FC */
	.short	0x67F8	/* 0x0000 */
	.short	0x11C0	/* 0xA205 */
	.short	0xA205	/* 0x11FC */
	.short	0x11C0	/* 0x0000 */
end28:

	.align	2
	.long	0x00005F0C	/* offset ROM */
	.long	end29-begin29
begin29:
	.short	0x11C0	/* 0x11FC */
	.short	0xA207	/* 0x0000 */
	.short	0x51C9	/* 0xA207 */
	.short	0xFFEA	/* 0x51C9 */
	.short	0x4E75	/* 0xFFEC */
end29:


/* XBIOS 112 */

	.align	2
	.long	0x00006030	/* offset ROM */
	.long	end30-begin30
begin30:
	.short	0x08C0	/* 0x0000 */
	.short	0x0007	/* 0x0080 */
end30:


/* XBIOS 113 */

	.align	2
	.long	0x000060D4	/* offset ROM */
	.long	end31-begin31
begin31:
	.short	0x3038	/* 0x3039 */
	.short	0x1790	/* 0x0000 */
	.short	0x5240	/* 0x1790 */
	.short	0x31C0	/* 0xD07C */
	.short	0x1790	/* 0x0001 */
	.short	0x4E75	/* 0x33C0 */
end31:


/* XBIOS 114 */

	.align	2
	.long	0x000060E6	/* offset ROM */
	.long	end32-begin32
begin32:
	.short	0x3038	/* 0x3039 */
	.short	0x178C	/* 0x0000 */
	.short	0x4E75	/* 0x178C */
end32:


/* XBIOS 115 */

	.align	2
	.long	0x0000570E	/* offset ROM */
	.long	end33-begin33
begin33:
	.short	0x41F8	/* 0x4E56 */
	.short	0x1720	/* 0xFFFC */
	.short	0x7008	/* 0x2F0D */
	.short	0x4290	/* 0x4BF9 */
	.short	0x4268	/* 0x0000 */
	.short	0x000A	/* 0x1720 */
	.short	0x41E8	/* 0x600A */
	.short	0x000C	/* 0x4295 */
	.short	0x51C8	/* 0x426D */
	.short	0xFFF4	/* 0x000A */
	.short	0x21F8	/* 0xDAFC */
	.short	0x1784	/* 0x000C */
	.short	0x1780	/* 0xBBFC */
	.short	0x4278	/* 0x0000 */
	.short	0x178E	/* 0x1780 */
	.short	0x4E75	/* 0x65EE */
end33:


/* XBIOS 116 */

	.align	2
	.long	0x00005744	/* offset ROM */
	.long	end34-begin34
begin34:
	.short	0x242F	/* 0x4E56 */
	.short	0x0008	/* 0xFFF8 */
	.short	0xB4BC	/* 0x48E7 */
	.short	0x0000	/* 0x0704 */
	.short	0x0400	/* 0x2E2E */
	.short	0x6E0E	/* 0x000C */
	.short	0x2038	/* 0x3C2E */
	.short	0x1788	/* 0x0010 */
	.short	0xD082	/* 0x0C87 */
	.short	0x2238	/* 0x0000 */
	.short	0x1780	/* 0x0400 */
	.short	0xB081	/* 0x6F06 */
	.short	0x6F06	/* 0x7000 */
	.short	0x7000	/* 0x6000 */
	.short	0x6000	/* 0x0146 */
	.short	0x0148	/* 0x2039 */
	.short	0x3038	/* 0x0000 */
	.short	0x178E	/* 0x1788 */
	.short	0xC0FC	/* 0xD087 */
	.short	0x000C	/* 0x2239 */
	.short	0x41F8	/* 0x0000 */
	.short	0x1720	/* 0x1780 */
	.short	0xD1C0	/* 0xB081 */
	.short	0x2010	/* 0x6F06 */
	.short	0x6700	/* 0x7000 */
	.short	0x0066	/* 0x6000 */
	.short	0x5380	/* 0x012E */
	.short	0x11FC	/* 0x3039 */
	.short	0x0096	/* 0x0000 */
	.short	0xA201	/* 0x178E */
	.short	0x0838	/* 0x48C0 */
	.short	0x0007	/* 0x4C3C */
	.short	0xA201	/* 0x0800 */
	.short	0x66F8	/* 0x0000 */
	.short	0x6100	/* 0x000C */
	.short	0x00F6	/* 0x41F9 */
	.short	0x0838	/* 0x0000 */
	.short	0x0001	/* 0x1720 */
	.short	0xA202	/* 0xD1C0 */
	.short	0x67F8	/* 0x2A48 */
	.short	0x21F8	/* 0x4A95 */
	.short	0x1784	/* 0x675E */
	.short	0xA204	/* 0x2015 */
	.short	0x9081	/* 0x2400 */
	.short	0x6100	/* 0x5382 */
	.short	0x00E2	/* 0x9081 */
	.short	0x3038	/* 0x5380 */
	.short	0x178E	/* 0x2F00 */
	.short	0xC0FC	/* 0x2F39 */
	.short	0x000C	/* 0x0000 */
	.short	0x41F8	/* 0x1784 */
	.short	0x1720	/* 0x2F02 */
	.short	0x2030	/* 0x4EBA */
	.short	0x0804	/* 0x0790 */
	.short	0x601E	/* 0x4FEF */
	.short	0xD190	/* 0x000C */
	.short	0x3228	/* 0x3039 */
	.short	0x0008	/* 0x0000 */
	.short	0x927C	/* 0x178E */
	.short	0x0017	/* 0x48C0 */
	.short	0xC3FC	/* 0x4C3C */
	.short	0x0006	/* 0x0800 */
	.short	0x5841	/* 0x0000 */
	.short	0x43F8	/* 0x000C */
	.short	0x17F7	/* 0x41F9 */
	.short	0x33A8	/* 0x0000 */
	.short	0x0002	/* 0x1720 */
	.short	0x1000	/* 0x2248 */
	.short	0x41E8	/* 0xD3C0 */
	.short	0x000C	/* 0x2A29 */
	.short	0xB1FC	/* 0x0004 */
	.short	0x0000	/* 0x2A48 */
	.short	0x1780	/* 0x6012 */
	.short	0x65DA	/* 0xDB95 */
	.short	0xD1B8	/* 0x3F2D */
	.short	0x1780	/* 0x0008 */
	.short	0x2038	/* 0x2F15 */
	.short	0x1780	/* 0x4EBA */
	.short	0x9082	/* 0x087A */
	.short	0x21C0	/* 0x5C4F */
	.short	0x1780	/* 0xDAFC */
	.short	0x5280	/* 0x000C */
	.short	0x3238	/* 0xBBFC */
	.short	0x178E	/* 0x0000 */
	.short	0xC2FC	/* 0x1780 */
	.short	0x000C	/* 0x65E6 */
	.short	0x41F8	/* 0xDBB9 */
	.short	0x1720	/* 0x0000 */
	.short	0xD1C1	/* 0x1780 */
	.short	0x48D0	/* 0x2039 */
	.short	0x0005	/* 0x0000 */
	.short	0x316F	/* 0x1780 */
	.short	0x000C	/* 0x9087 */
	.short	0x000A	/* 0x2200 */
	.short	0x3228	/* 0x5281 */
	.short	0x0008	/* 0x3439 */
	.short	0x927C	/* 0x0000 */
	.short	0x0017	/* 0x178E */
	.short	0xC3FC	/* 0x48C2 */
	.short	0x0006	/* 0x4C3C */
	.short	0x5841	/* 0x2800 */
	.short	0x41F8	/* 0x0000 */
	.short	0x17F7	/* 0x000C */
	.short	0x3180	/* 0x41F9 */
	.short	0x1000	/* 0x0000 */
	.short	0x11FC	/* 0x1720 */
	.short	0x0095	/* 0xD1C2 */
	.short	0xA201	/* 0x2081 */
	.short	0x0838	/* 0x2147 */
	.short	0x0007	/* 0x0004 */
	.short	0xA201	/* 0x3146 */
	.short	0x66F8	/* 0x000A */
	.short	0x702E	/* 0x23C0 */
	.short	0x6158	/* 0x0000 */
	.short	0x7010	/* 0x1780 */
	.short	0x6154	/* 0x3F28 */
	.short	0x41F8	/* 0x0008 */
	.short	0x17F7	/* 0x2F01 */
	.short	0x615C	/* 0x4EBA */
	.short	0x11FC	/* 0x0828 */
	.short	0x0095	/* 0x4EBA */
	.short	0xA201	/* 0x075E */
	.short	0x0838	/* 0x4EBA */
	.short	0x0007	/* 0x074A */
	.short	0xA201	/* 0x3039 */
	.short	0x66F8	/* 0x0000 */
	.short	0x3038	/* 0x178E */
	.short	0x178E	/* 0x48C0 */
	.short	0xC0FC	/* 0x4C3C */
	.short	0x000C	/* 0x0800 */
	.short	0x41F8	/* 0x0000 */
	.short	0x1720	/* 0x000C */
	.short	0xD1C0	/* 0x41F9 */
	.short	0x2018	/* 0x0000 */
	.short	0x612E	/* 0x1720 */
	.short	0x2010	/* 0xD1C0 */
	.short	0x612A	/* 0x2EA8 */
	.short	0x2002	/* 0x0004 */
	.short	0x206F	/* 0x2F10 */
	.short	0x0004	/* 0x4EBA */
	.short	0x6130	/* 0x06BC */
	.short	0x3038	/* 0x7000 */
	.short	0x178E	/* 0x2E80 */
	.short	0x5278	/* 0x2F00 */
	.short	0x178E	/* 0x2F07 */
	.short	0x0C78	/* 0x2F2E */
end34:

	.align	2
	.long	0x0000586A	/* offset ROM */
	.long	end35-begin35
begin35:
	.short	0x178E	/* 0x4EBA */
	.short	0x6D04	/* 0xF8A8 */
	.short	0x4278	/* 0x4FEF */
	.short	0x178E	/* 0x0016 */
	.short	0xC0FC	/* 0x3C39 */
	.short	0x000C	/* 0x0000 */
	.short	0x41F8	/* 0x178E */
	.short	0x1720	/* 0x5279 */
	.short	0x3030	/* 0x0000 */
	.short	0x0808	/* 0x178E */
	.short	0x602A	/* 0x0C79 */
	.short	0x0838	/* 0x0008 */
	.short	0x0001	/* 0x0000 */
	.short	0xA202	/* 0x178E */
	.short	0x67F8	/* 0x6D06 */
	.short	0x21C0	/* 0x4279 */
	.short	0xA204	/* 0x0000 */
	.short	0x601C	/* 0x178E */
	.short	0x5340	/* 0x2006 */
	.short	0x6B18	/* 0x48C0 */
	.short	0x0838	/* 0x4C3C */
	.short	0x0001	/* 0x0800 */
	.short	0xA202	/* 0x0000 */
	.short	0x67F8	/* 0x000C */
	.short	0x11D8	/* 0x41F9 */
	.short	0xA205	/* 0x0000 */
	.short	0x11D8	/* 0x1720 */
	.short	0xA206	/* 0xD1C0 */
	.short	0x11D8	/* 0x3028 */
	.short	0xA207	/* 0x0008 */
	.short	0x51C8	/* 0x4CDF */
	.short	0xFFEA	/* 0x20E0 */
	.short	0x4E75	/* 0x4E5E */
end35:


/* XBIOS 117 */

	.align	2
	.long	0x000060F2	/* offset ROM */
	.long	end36-begin36
begin36:
	.short	0x41F8	/* 0x41F9 */
	.short	0x1720	/* 0x0000 */
	.short	0x7407	/* 0x1720 */
end36:

	.align	2
	.long	0x00006100	/* offset ROM */
	.long	end37-begin37
begin37:
	.short	0x670A	/* 0x6700 */
	.short	0x41E8	/* 0x0012 */
	.short	0x000C	/* 0x41E8 */
	.short	0x51CA	/* 0x000C */
	.short	0xFFF2	/* 0xB0BC */
	.short	0x7000	/* 0x0000 */
	.short	0x4E75	/* 0x001E */
end37:


/* XBIOS 118 */

	.align	2
	.long	0x00005FEA	/* offset ROM */
	.long	end38-begin38
begin38:
	.short	0x6D36	/* 0x6D00 */
	.short	0xB03C	/* 0x003A */
	.short	0x001E	/* 0xB03C */
	.short	0x6E30	/* 0x001E */
	.short	0x927C	/* 0x6E00 */
	.short	0x0017	/* 0x0032 */
	.short	0xC3FC	/* 0x927C */
	.short	0x0006	/* 0x0017 */
	.short	0x5641	/* 0xC3FC */
	.short	0x41F8	/* 0x0006 */
	.short	0x17F7	/* 0xD27C */
	.short	0xD0C1	/* 0x0003 */
	.short	0x0838	/* 0x41F9 */
	.short	0x0001	/* 0x0000 */
	.short	0xA202	/* 0x17F7 */
	.short	0x67F8	/* 0xD0C1 */
end38:

	.align	2
	.long	0x00006016	/* offset ROM */
	.long	end39-begin39
begin39:
	.short	0x08C0	/* 0x0000 */
	.short	0x0007	/* 0x0080 */
end39:

	.align	2
	.long	0x0000601E	/* offset ROM */
	.long	end40-begin40
begin40:
	.short	0x7000	/* 0x303C */
	.short	0x6002	/* 0x0000 */
	.short	0x70FF	/* 0x6000 */
	.short	0x4E75	/* 0x0006 */
end40:


/* XBIOS 119 */

	.align	2
	.long	0x0000613A	/* offset ROM */
	.long	end41-begin41
begin41:
	.short	0x302F	/* 0x322F */
end41:

	.align	2
	.long	0x0000613E	/* offset ROM */
	.long	end42-begin42
begin42:
	.short	0xB07C	/* 0xB27C */
end42:

	.align	2
	.long	0x00006142	/* offset ROM */
	.long	end43-begin43
begin43:
	.short	0x671A	/* 0x6700 */
	.short	0xB07C	/* 0x0026 */
	.short	0x0001	/* 0xB27C */
	.short	0x6608	/* 0x0001 */
	.short	0x08F8	/* 0x6600 */
	.short	0x0003	/* 0x000C */
	.short	0xA200	/* 0x08F8 */
	.short	0x6018	/* 0x0003 */
	.short	0x4A40	/* 0xA200 */
	.short	0x6614	/* 0x6000 */
	.short	0x08B8	/* 0x0026 */
	.short	0x0003	/* 0xB27C */
	.short	0xA200	/* 0x0000 */
	.short	0x600C	/* 0x6600 */
	.short	0x7000	/* 0x001E */
	.short	0x0838	/* 0x08B8 */
end43:

	.align	2
	.long	0x00006166	/* offset ROM */
	.long	end44-begin44
begin44:
	.short	0x6702	/* 0x6000 */
	.short	0x7001	/* 0x0014 */
	.short	0x4E75	/* 0x303C */
end44:


/* XBIOS 120 */

	.align	2
	.long	0x0000617E	/* offset ROM */
	.long	end45-begin45
begin45:
	.short	0x302F	/* 0x322F */
end45:

	.align	2
	.long	0x00006182	/* offset ROM */
	.long	end46-begin46
begin46:
	.short	0xB07C	/* 0xB27C */
end46:

	.align	2
	.long	0x00006186	/* offset ROM */
	.long	end47-begin47
begin47:
	.short	0x671A	/* 0x6700 */
	.short	0xB07C	/* 0x0026 */
	.short	0x0001	/* 0xB27C */
	.short	0x6608	/* 0x0001 */
	.short	0x08F8	/* 0x6600 */
	.short	0x0004	/* 0x000C */
	.short	0xA200	/* 0x08F8 */
	.short	0x6018	/* 0x0004 */
	.short	0x4A40	/* 0xA200 */
	.short	0x6614	/* 0x6000 */
	.short	0x08B8	/* 0x0026 */
	.short	0x0004	/* 0xB27C */
	.short	0xA200	/* 0x0000 */
	.short	0x600C	/* 0x6600 */
	.short	0x7000	/* 0x001E */
	.short	0x0838	/* 0x08B8 */
end47:

	.align	2
	.long	0x000061AA	/* offset ROM */
	.long	end48-begin48
begin48:
	.short	0x6702	/* 0x6000 */
	.short	0x7001	/* 0x0014 */
	.short	0x4E75	/* 0x303C */
end48:


/* XBIOS 121 */

	.align	2
	.long	0x000061C2	/* offset ROM */
	.long	end49-begin49
begin49:
	.short	0x7000	/* 0x303C */
	.short	0x0838	/* 0x0000 */
	.short	0x0003	/* 0x0838 */
	.short	0xA202	/* 0x0003 */
	.short	0x6702	/* 0xA202 */
	.short	0x7001	/* 0x6700 */
	.short	0x4E75	/* 0x0006 */
end49:


/* XBIOS 122 */

	.align	2
	.long	0x000061D6	/* offset ROM */
	.long	end50-begin50
begin50:
	.short	0x7000	/* 0x303C */
	.short	0x0838	/* 0x0000 */
	.short	0x0004	/* 0x0838 */
	.short	0xA202	/* 0x0004 */
	.short	0x6702	/* 0xA202 */
	.short	0x7001	/* 0x6700 */
	.short	0x4E75	/* 0x0006 */
end50:


/* XBIOS 123 */

	.align	2
	.long	0x0000520A	/* offset ROM */
	.long	end51-begin51
begin51:
	.short	0x5380	/* 0x4A80 */
	.short	0x6B14	/* 0x6700 */
	.short	0x0838	/* 0x0018 */
	.short	0x0001	/* 0x5340 */
	.short	0xA202	/* 0x0838 */
	.short	0x67F8	/* 0x0001 */
	.short	0x3418	/* 0xA202 */
	.short	0x48C2	/* 0x67F8 */
	.short	0x21C2	/* 0x3418 */
	.short	0xA204	/* 0x48C2 */
	.short	0x51C8	/* 0x21C2 */
	.short	0xFFEE	/* 0xA204 */
	.short	0x5381	/* 0x51C8 */
	.short	0x6B14	/* 0xFFF6 */
	.short	0x0838	/* 0x4A81 */
	.short	0x0000	/* 0x6700 */
	.short	0xA202	/* 0x0018 */
	.short	0x67F8	/* 0x5341 */
	.short	0x12F8	/* 0x0838 */
	.short	0xA206	/* 0x0000 */
	.short	0x12F8	/* 0xA202 */
	.short	0xA207	/* 0x67F8 */
	.short	0x51C9	/* 0x12F8 */
	.short	0xFFEE	/* 0xA206 */
	.short	0x4E75	/* 0x12F8 */
end51:


/* XBIOS 124 */

	.align	2
	.long	0x00005254	/* offset ROM */
	.long	end52-begin52
begin52:
	.short	0x5380	/* 0x4A80 */
	.short	0x6B1C	/* 0x6700 */
	.short	0x0838	/* 0x0020 */
	.short	0x0001	/* 0x5340 */
	.short	0xA202	/* 0x0838 */
	.short	0x67F8	/* 0x0001 */
	.short	0x11FC	/* 0xA202 */
	.short	0x0000	/* 0x67F8 */
	.short	0xA205	/* 0x11FC */
	.short	0x11FC	/* 0x0000 */
	.short	0x0000	/* 0xA205 */
	.short	0xA206	/* 0x11FC */
	.short	0x11D8	/* 0x0000 */
	.short	0xA207	/* 0xA206 */
	.short	0x51C8	/* 0x11D8 */
	.short	0xFFE6	/* 0xA207 */
	.short	0x5381	/* 0x51C8 */
	.short	0x6B14	/* 0xFFEE */
	.short	0x0838	/* 0x4A81 */
	.short	0x0000	/* 0x6700 */
	.short	0xA202	/* 0x0018 */
	.short	0x67F8	/* 0x5341 */
	.short	0x1438	/* 0x0838 */
	.short	0xA206	/* 0x0000 */
	.short	0x12F8	/* 0xA202 */
	.short	0xA207	/* 0x67F8 */
	.short	0x51C9	/* 0x1438 */
	.short	0xFFEE	/* 0xA206 */
	.short	0x4E75	/* 0x12F8 */
end52:


/* XBIOS 125 */


/* XBIOS 126 */

	.align	2
	.long	0x000054C6	/* offset ROM */
	.long	end53-begin53
begin53:
	.short	0x21EF	/* 0x23FC */
	.short	0x0004	/* 0x0000 */
	.short	0x16F4	/* 0x0000 */
	.short	0x6714	/* 0x0000 */
	.short	0x41FA	/* 0x16F0 */
	.short	0x0030	/* 0x23FC */
	.short	0x21C8	/* 0x0000 */
	.short	0x03FC	/* 0x0000 */
	.short	0x11FC	/* 0x0000 */
	.short	0x00FF	/* 0x16F4 */
	.short	0xA203	/* 0x202F */
	.short	0x08F8	/* 0x0004 */
	.short	0x0000	/* 0x6700 */
	.short	0xA200	/* 0x001C */
	.short	0x21EF	/* 0x23C0 */
	.short	0x0008	/* 0x0000 */
end53:

	.align	2
	.long	0x000054E8	/* offset ROM */
	.long	end54-begin54
begin54:
	.short	0x6714	/* 0x21FC */
	.short	0x41FA	/* 0x00E0 */
	.short	0x0014	/* 0x5520 */
	.short	0x21C8	/* 0x03FC */
	.short	0x03FC	/* 0x11FC */
	.short	0x11FC	/* 0x00FF */
	.short	0x00FF	/* 0xA203 */
	.short	0xA203	/* 0x0038 */
	.short	0x08F8	/* 0x0001 */
	.short	0x0001	/* 0xA200 */
	.short	0xA200	/* 0x202F */
	.short	0x4E75	/* 0x0008 */
	.short	0x48E7	/* 0x6700 */
	.short	0xE0E0	/* 0x001C */
	.short	0x0838	/* 0x23C0 */
end54:

	.align	2
	.long	0x00005508	/* offset ROM */
	.long	end55-begin55
begin55:
	.short	0xA202	/* 0x16F4 */
	.short	0x6720	/* 0x21FC */
	.short	0x2038	/* 0x00E0 */
	.short	0x16F4	/* 0x5520 */
	.short	0x671A	/* 0x03FC */
	.short	0x2040	/* 0x11FC */
	.short	0x7000	/* 0x00FF */
	.short	0x1038	/* 0xA203 */
	.short	0xA205	/* 0x0038 */
	.short	0xE198	/* 0x0002 */
	.short	0x1038	/* 0xA200 */
	.short	0xA206	/* 0x4E75 */
	.short	0xE198	/* 0x48E7 */
	.short	0x1038	/* 0xE0E0 */
	.short	0xA207	/* 0x0838 */
	.short	0x2F00	/* 0x0000 */
	.short	0x4E90	/* 0xA202 */
	.short	0x584F	/* 0x6700 */
	.short	0x0838	/* 0x0026 */
	.short	0x0001	/* 0x2039 */
	.short	0xA202	/* 0x0000 */
	.short	0x6720	/* 0x16F0 */
	.short	0x2038	/* 0x6700 */
	.short	0x16F0	/* 0x001C */
	.short	0x671A	/* 0x2040 */
	.short	0x2040	/* 0x7000 */
	.short	0x4E90	/* 0x1038 */
	.short	0x4A80	/* 0xA205 */
	.short	0x6712	/* 0xE198 */
	.short	0x4840	/* 0x1038 */
	.short	0x11C0	/* 0xA206 */
	.short	0xA205	/* 0xE198 */
	.short	0xE198	/* 0x1038 */
	.short	0x11C0	/* 0xA207 */
	.short	0xA206	/* 0x2F00 */
	.short	0xE198	/* 0x4E90 */
	.short	0x11C0	/* 0x588F */
	.short	0xA207	/* 0x0838 */
	.short	0x4CDF	/* 0x0001 */
	.short	0x0707	/* 0xA202 */
	.short	0x4E73	/* 0x6700 */
end55:


/* XBIOS 127 */

	.align	2
	.long	0x0000558C	/* offset ROM */
	.long	end56-begin56
begin56:
	.short	0x6770	/* 0x6700 */
	.short	0x206F	/* 0x0078 */
	.short	0x000C	/* 0x0838 */
	.short	0x5340	/* 0x0001 */
	.short	0x3210	/* 0xA202 */
	.short	0x2428	/* 0x67F8 */
	.short	0x0002	/* 0x206F */
	.short	0x5382	/* 0x000C */
	.short	0x2268	/* 0x907C */
	.short	0x0006	/* 0x0001 */
	.short	0x4A41	/* 0x3210 */
	.short	0x6612	/* 0x2428 */
	.short	0x0838	/* 0x0002 */
	.short	0x0001	/* 0x5382 */
	.short	0xA202	/* 0x2268 */
	.short	0x67F8	/* 0x0006 */
	.short	0x21D9	/* 0xB27C */
	.short	0xA204	/* 0x0000 */
	.short	0x51CA	/* 0x6700 */
	.short	0xFFF2	/* 0x0018 */
	.short	0x6040	/* 0xB27C */
	.short	0xB27C	/* 0x0001 */
	.short	0x0001	/* 0x6700 */
	.short	0x6616	/* 0x001E */
	.short	0x0838	/* 0xB27C */
	.short	0x0001	/* 0x0002 */
	.short	0xA202	/* 0x6700 */
	.short	0x67F8	/* 0x0028 */
	.short	0x3219	/* 0x4EF9 */
	.short	0x48C1	/* 0x00E0 */
	.short	0x21C1	/* 0x567C */
	.short	0xA204	/* 0x21D9 */
	.short	0x51CA	/* 0xA204 */
	.short	0xFFEE	/* 0x51CA */
	.short	0x6024	/* 0xFFFA */
	.short	0xB27C	/* 0x4EF9 */
	.short	0x0002	/* 0x00E0 */
	.short	0x6600	/* 0x55FE */
	.short	0x0092	/* 0x3219 */
	.short	0x0838	/* 0x48C1 */
	.short	0x0001	/* 0x21C1 */
	.short	0xA202	/* 0xA204 */
	.short	0x67F8	/* 0x51CA */
	.short	0x11FC	/* 0xFFF6 */
	.short	0x0000	/* 0x4EF9 */
	.short	0xA205	/* 0x00E0 */
	.short	0x11FC	/* 0x55FE */
	.short	0x0000	/* 0x11FC */
	.short	0xA206	/* 0x0000 */
	.short	0x11D9	/* 0xA205 */
	.short	0xA207	/* 0x11FC */
	.short	0x51CA	/* 0x0000 */
	.short	0xFFE6	/* 0xA206 */
	.short	0x41E8	/* 0x11D9 */
	.short	0x000A	/* 0xA207 */
	.short	0x51C8	/* 0x51CA */
	.short	0xFF98	/* 0xFFEE */
	.short	0x202F	/* 0x41E8 */
	.short	0x0008	/* 0x000A */
	.short	0x6766	/* 0x51C8 */
	.short	0x206F	/* 0xFF9C */
	.short	0x0010	/* 0x202F */
	.short	0x5340	/* 0x0008 */
	.short	0x3210	/* 0x6700 */
	.short	0x2428	/* 0x0070 */
	.short	0x0002	/* 0x0838 */
	.short	0x5382	/* 0x0000 */
	.short	0x2268	/* 0xA202 */
	.short	0x0006	/* 0x67F8 */
	.short	0x4A41	/* 0x206F */
	.short	0x6612	/* 0x0010 */
	.short	0x0838	/* 0x907C */
	.short	0x0000	/* 0x0001 */
	.short	0xA202	/* 0x3210 */
	.short	0x67F8	/* 0x2428 */
	.short	0x22F8	/* 0x0002 */
	.short	0xA204	/* 0x5382 */
	.short	0x51CA	/* 0x2268 */
	.short	0xFFF2	/* 0x0006 */
	.short	0x6036	/* 0xB27C */
	.short	0xB27C	/* 0x0000 */
	.short	0x0001	/* 0x6700 */
	.short	0x6616	/* 0x0018 */
	.short	0x0838	/* 0xB27C */
	.short	0x0000	/* 0x0001 */
	.short	0xA202	/* 0x6700 */
	.short	0x67F8	/* 0x001E */
	.short	0x12F8	/* 0xB27C */
	.short	0xA206	/* 0x0002 */
	.short	0x12F8	/* 0x6700 */
	.short	0xA207	/* 0x0028 */
	.short	0x51CA	/* 0x4EF9 */
	.short	0xFFEE	/* 0x00E0 */
	.short	0x601A	/* 0x567C */
	.short	0xB27C	/* 0x22F8 */
	.short	0x0002	/* 0xA204 */
	.short	0x661C	/* 0x51CA */
	.short	0x0838	/* 0xFFFA */
	.short	0x0000	/* 0x4EF9 */
	.short	0xA202	/* 0x00E0 */
	.short	0x67F8	/* 0x5674 */
	.short	0x1238	/* 0x12F8 */
end56:

	.align	2
	.long	0x00005660	/* offset ROM */
	.long	end57-begin57
begin57:
	.short	0xFFEE	/* 0xFFF6 */
	.short	0x41E8	/* 0x4EF9 */
	.short	0x000A	/* 0x00E0 */
	.short	0x51C8	/* 0x5674 */
	.short	0xFFA2	/* 0x1238 */
	.short	0x4E75	/* 0xA206 */
end57:
